function  M_Array=collect_properties(inert,reactive)
%this function collects data from the table for the inert and reactive
%components, into a cell array. the array can be accessed more conveniently
%and with shorter runtimes then a table.
%parameters are collected at the same order they are retrieved in the
%function "mixture_properties"

%input parameters- names of inert and reactive component.
%list of names can be found in the file "property_tables"

if iscell(reactive)
    %% mixture of two reactives  
    M_Array={collect_properties(inert,reactive{1}),...
        collect_properties(inert,reactive{3});reactive{2},reactive{4}};
elseif iscell(inert)
    %% mixture of two inerts
    M_Array={collect_properties(inert{1},reactive),...
        collect_properties(inert{3},reactive);inert{2},inert{4}};  
else
    %% pure gas
    load('property_tables.mat','Property_Tables')
    M_Array=cell(25,1);
    M_Array{1}=(Property_Tables.LH{{reactive},1});
    M_Array{2}=Property_Tables.Parameters{{inert},{'Mw'}};
    M_Array{3}=Property_Tables.Parameters{{reactive},{'Mw'}};
    M_Array{4}=Property_Tables.Parameters{{inert},{'miu'}};
    M_Array{5}=Property_Tables.Parameters{{reactive},{'miu'}};
    M_Array{6}=Property_Tables.Parameters{{inert},{'Tb'}};
    M_Array{7}=Property_Tables.Parameters{{reactive},{'Tb'}};
    M_Array{8}=Property_Tables.Parameters{{inert},{'Tc'}};
    M_Array{9}=Property_Tables.Parameters{{reactive},{'Tc'}};
    M_Array{10}=Property_Tables.Parameters{{inert},{'omega'}};
    M_Array{11}=Property_Tables.Parameters{{reactive},{'omega'}};
    M_Array{12}=Property_Tables.Parameters{{inert},{'kappa'}};
    M_Array{13}=Property_Tables.Parameters{{reactive},{'kappa'}};
    M_Array{14}=Property_Tables.Parameters{{inert},{'a0','a1','a2','a3','a4'}};
    M_Array{15}=Property_Tables.Parameters{{reactive},{'a0','a1','a2','a3','a4'}};
    M_Array{16}=Property_Tables.Parameters{{inert},{'Vc'}};
    M_Array{17}=Property_Tables.Parameters{{reactive},{'Vc'}};
    M_Array{18}=Property_Tables.LH{{reactive},:};
    M_Array{19}=Property_Tables.TB{{reactive},:};
    M_Array{20}=Property_Tables.Parameters{{inert},{'ek'}};
    M_Array{21}=Property_Tables.Parameters{{reactive},{'ek'}};
    M_Array{22}=Property_Tables.Parameters{{inert},{'sig'}};
    M_Array{23}=Property_Tables.Parameters{{reactive},{'sig'}};
    M_Array{24}=Property_Tables.Parameters{{reactive},{'beta'}};
    M_Array{25}=Property_Tables.Parameters{{inert},{'beta'}};
end

end

